<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Health Records - Tammeny</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
    </style>
</head>
<body class="bg-slate-50 text-slate-900">

    <!-- Navbar -->
    <nav class="bg-white border-b border-slate-200 sticky top-0 z-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center gap-8">
                    <a href="<?php echo e(url('/')); ?>" class="flex-shrink-0 flex items-center gap-2">
                        <div class="w-8 h-8 bg-blue-600 rounded-lg flex items-center justify-center text-white font-bold text-lg">T</div>
                        <span class="font-bold text-xl tracking-tight text-slate-900">Tammeny</span>
                    </a>
                    <div class="hidden md:flex gap-6">
                        <a href="<?php echo e(route('home')); ?>" class="text-sm font-medium text-slate-600 hover:text-blue-600 transition-colors">Home</a>
                        <a href="<?php echo e(route('ehr.index')); ?>" class="text-sm font-medium text-blue-600">My Records</a>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <div class="flex items-center gap-3 pl-6 border-l border-slate-200">
                        <span class="text-sm font-medium text-slate-700"><?php echo e(Auth::user()->name); ?></span>
                        <form method="POST" action="<?php echo e(route('logout')); ?>">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="text-sm text-slate-500 hover:text-red-600 transition-colors">Logout</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </nav>

    <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-10">
        
        <div class="mb-10">
            <h1 class="text-3xl font-bold text-slate-900">Electronic Health Records</h1>
            <p class="text-slate-600 mt-2">Access your complete medical history, reports, and radiology analysis.</p>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            
            <!-- Lab Reports Section -->
            <section class="bg-white rounded-2xl border border-slate-200 shadow-sm overflow-hidden">
                <div class="p-6 border-b border-slate-100 flex justify-between items-center bg-slate-50/50">
                    <div class="flex items-center gap-3">
                        <div class="p-2 bg-blue-100 text-blue-600 rounded-lg">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                        </div>
                        <h2 class="text-lg font-bold text-slate-900">Lab Reports</h2>
                    </div>
                    <div class="flex items-center gap-3">
                        <a href="<?php echo e(route('reports.index')); ?>" class="text-sm font-medium text-blue-600 hover:text-blue-700 flex items-center gap-1">
                            New Report <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
                        </a>
                    </div>
                </div>
                
                <div class="divide-y divide-slate-100">
                    <?php $__empty_1 = true; $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="block p-5 hover:bg-slate-50 transition-colors group relative">
                            <a href="<?php echo e(route('reports.show', $report->id)); ?>" class="block">
                                <div class="flex justify-between items-start mb-1">
                                    <h3 class="font-semibold text-slate-900 group-hover:text-blue-600 transition-colors"><?php echo e($report->title ?? 'Untitled Report'); ?></h3>
                                    <span class="text-xs font-medium text-slate-500 bg-slate-100 px-2.5 py-1 rounded-full"><?php echo e($report->created_at->format('M d, Y')); ?></span>
                                </div>
                                <p class="text-sm text-slate-500 line-clamp-2 pr-10">
                                    <?php echo e($report->summary ?? 'Click to view analysis and chat history.'); ?>

                                </p>
                            </a>
                            <button onclick="shareItem('report', <?php echo e($report->id); ?>)" class="absolute bottom-5 right-5 p-2 text-slate-400 hover:text-blue-600 transition-colors" title="Share">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z"></path></svg>
                            </button>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="p-8 text-center">
                            <div class="inline-flex items-center justify-center w-12 h-12 rounded-full bg-slate-100 text-slate-400 mb-3">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path></svg>
                            </div>
                            <p class="text-slate-900 font-medium">No reports yet</p>
                            <p class="text-sm text-slate-500 mt-1">Upload your first lab report to get started.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </section>

            <!-- Radiology Section -->
            <section class="bg-white rounded-2xl border border-slate-200 shadow-sm overflow-hidden">
                <div class="p-6 border-b border-slate-100 flex justify-between items-center bg-slate-50/50">
                    <div class="flex items-center gap-3">
                        <div class="p-2 bg-purple-100 text-purple-600 rounded-lg">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.384-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path></svg>
                        </div>
                        <h2 class="text-lg font-bold text-slate-900">Radiology</h2>
                    </div>
                    <div class="flex items-center gap-3">
                        <a href="<?php echo e(route('radiology.index')); ?>" class="text-sm font-medium text-purple-600 hover:text-purple-700 flex items-center gap-1">
                            New Scan <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path></svg>
                        </a>
                    </div>
                </div>

                <div class="divide-y divide-slate-100">
                    <?php $__empty_1 = true; $__currentLoopData = $radiologyReports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $xray): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="block p-5 hover:bg-slate-50 transition-colors group relative">
                            <a href="<?php echo e(route('radiology.show', $xray->id)); ?>" class="block">
                                <div class="flex justify-between items-start mb-1">
                                    <h3 class="font-semibold text-slate-900 group-hover:text-purple-600 transition-colors">
                                        <?php echo e($xray->title ?? 'X-Ray Analysis'); ?>

                                    </h3>
                                    <span class="text-xs font-medium text-slate-500 bg-slate-100 px-2.5 py-1 rounded-full"><?php echo e($xray->created_at->format('M d, Y')); ?></span>
                                </div>
                                <p class="text-sm text-slate-500 line-clamp-2 pr-10">
                                    <?php echo e($xray->impression ?? 'Click to view analysis and chat history.'); ?>

                                </p>
                            </a>
                            <button onclick="shareItem('radiology', <?php echo e($xray->id); ?>)" class="absolute bottom-5 right-5 p-2 text-slate-400 hover:text-purple-600 transition-colors" title="Share">
                                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8.684 13.342C8.886 12.938 9 12.482 9 12c0-.482-.114-.938-.316-1.342m0 2.684a3 3 0 110-2.684m0 2.684l6.632 3.316m-6.632-6l6.632-3.316m0 0a3 3 0 105.367-2.684 3 3 0 00-5.367 2.684zm0 9.316a3 3 0 105.368 2.684 3 3 0 00-5.368-2.684z"></path></svg>
                            </button>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <div class="p-8 text-center">
                            <div class="inline-flex items-center justify-center w-12 h-12 rounded-full bg-slate-100 text-slate-400 mb-3">
                                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.384-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path></svg>
                            </div>
                            <p class="text-slate-900 font-medium">No scans yet</p>
                            <p class="text-sm text-slate-500 mt-1">Upload your first X-ray to get started.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </section>

        </div>
    </main>

    </main>

    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <script>
        async function shareItem(type, id) {
            try {
                const response = await axios.post(`/share/generate/${type}/${id}`, {}, {
                    headers: {
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    }
                });
                
                if (response.data.status === 'success') {
                    navigator.clipboard.writeText(response.data.url);
                    alert('Link copied to clipboard!');
                }
            } catch (error) {
                console.error('Error generating link:', error);
                const msg = error.response?.data?.message || 'Failed to generate share link.';
                alert(msg);
            }
        }
    </script>
</body>
</html>
<?php /**PATH D:\Tammeny\resources\views/ehr/dashboard.blade.php ENDPATH**/ ?>