<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ChatBotController;
use App\Http\Controllers\RadiologyController;
use App\Http\Controllers\EHRController;

Route::get('/', function () {
    return view('home');
})->name('home');

// Route::get('/chat-report', function () {
//     return view('chat-report');
// })->name('chat.report');

// Route::get('/chat-xray', function () {
//     return view('chat-xray');
// })->name('chat.xray');


// ======================
// Lab Reports (Web)
// ======================

Route::middleware(['auth'])->group(function () {
    // EHR Dashboard
    Route::get('/ehr', [EHRController::class, 'index'])->name('ehr.index');

    // صفحة كتابة التقرير + رفع الصورة
    Route::get('/reports', function () {
        return view('chat-report'); // صفحة الشات + رفع ملف
    })->name('reports.index');

    // عرض تقرير معين (Resume Chat)
    Route::get('/reports/{id}', [ChatBotController::class, 'show'])->name('reports.show');

    // إرسال أول رسالة (start report)
    Route::post('/reports/start', [ChatBotController::class, 'startReport'])
        ->name('reports.start');

    // رفع صورة المعمل
    Route::post('/reports/upload-lab-image', [ChatBotController::class, 'uploadLabImage'])
        ->name('reports.uploadLabImage');

    // شات مع التقرير
    Route::post('/reports/chat', [ChatBotController::class, 'chatWithReport'])
        ->name('reports.chat');

    // عرض الـ history لتقرير معيّن
    Route::get('/reports/{report_id}/history', [ChatBotController::class, 'getReportHistory'])
        ->name('reports.history');

    // ======================
    // Radiology (Web)
    // ======================

    // صفحة رفع صورة الأشعة والشات
    Route::get('/radiology', function () {
        return view('chat-xray'); // صفحة الشات + رفع الأشعة
    })->name('radiology.index');

    // عرض تقرير أشعة معين (Resume Chat)
    Route::get('/radiology/{id}', [RadiologyController::class, 'show'])->name('radiology.show');

    // رفع صورة الأشعة
    Route::post('/radiology/upload', [RadiologyController::class, 'uploadRadiology'])
        ->name('radiology.upload');

    // شات مع تقرير الأشعة
    Route::post('/radiology/chat', [RadiologyController::class, 'chat'])
        ->name('radiology.chat');

    // عرض الـ chat history
    Route::get('/radiology/history/{report_id}', [RadiologyController::class, 'history'])
        ->name('radiology.history');

    // عرض تقرير أشعة كامل
    Route::get('/radiology/report/{report_id}', [RadiologyController::class, 'getReport'])
        ->name('radiology.single');

    // Share Routes (Authenticated to generate)
    Route::post('/share/generate/{type}/{id}', [App\Http\Controllers\ShareController::class, 'generateLink'])
        ->name('share.generate');
});

// Public Share Routes
Route::get('/share/report/{token}', [App\Http\Controllers\ShareController::class, 'viewReport'])->name('share.report');
Route::get('/share/radiology/{token}', [App\Http\Controllers\ShareController::class, 'viewRadiology'])->name('share.radiology');

// ------------Test Groq API ------------
Route::get('/test-groq', function() {
    \Log::info('Testing Groq API');
    
    $response = Http::withHeaders([
        "Authorization" => "Bearer " . env("GROQ_API_KEY"),
        "Content-Type" => "application/json"
    ])->post('https://api.groq.com/openai/v1/chat/completions', [
        "model" => "llama-3.3-70b-versatile",
        "messages" => [
            ["role" => "user", "content" => "Say hello"]
        ]
    ]);
    
    return response()->json([
        'key_exists' => env("GROQ_API_KEY") ? 'yes' : 'no',
        'key_length' => strlen(env("GROQ_API_KEY") ?? ''),
        'status' => $response->successful() ? 'success' : 'failed',
        'response' => $response->json()
    ]);
});

// ---check groq & google keys---
Route::get('/check-keys', function() {
    $key = env('GROQ_API_KEY');
    $url = env('GROQ_API_URL');
    
    $Google_key = env('GOOGLE_API_KEY');
    $Google_url = env('GOOGLE_API_URL');

    return response()->json([
        'GROQ_API_KEY' => $key ? '✅ موجود' : '❌ مش موجود',
        'GROQ_API_URL' => $url ? '✅ موجود' : '❌ مش موجود',
        'GOOGLE_API_KEY' => $Google_key ? '✅ موجود' : '❌ مش موجود',
        'GOOGLE_API_URL' => $Google_url ? '✅ موجود' : '❌ مش موجود'
    ]);
});


require __DIR__.'/auth.php';
