<?php

use App\Http\Controllers\AIChatController;
use App\Http\Controllers\AIController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ChatBotController;
use App\Http\Controllers\RadiologyController;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

Route::post('/ai/analyze-lab', [AIController::class, 'analyzeLabImage']);
Route::post('/ai/chat', [AIChatController::class, 'chat']);


// ChatBot Routes CHAT-GPT
// Route::middleware('auth:sanctum')->group(function() {
    Route::post('/reports/start', [ChatBotController::class, 'startReport']);
    Route::post('/reports/upload-lab-image', [ChatBotController::class, 'uploadLabImage']);
    Route::post('/reports/chat', [ChatBotController::class, 'chatWithReport']);
    Route::get('/reports/{report_id}/history', [ChatBotController::class, 'getReportHistory']);
// });


// Radiology Routes

// Route::middleware('auth:sanctum')->group(function() {
// 1) Upload radiology image (X-ray, MRI, CT…)
Route::post('/radiology/upload', [RadiologyController::class, 'uploadRadiology']);

// 2) Chat with radiology report
Route::post('/radiology/chat', [RadiologyController::class, 'chat']);

// 3) Get radiology chat history for a report
Route::get('/radiology/history/{report_id}', [RadiologyController::class, 'history']);

// 4) Get a single radiology report
Route::get('/radiology/report/{report_id}', [RadiologyController::class, 'getReport']);

// 5) Get all radiology reports for a user
// Route::get('/radiology/reports', [RadiologyController::class, 'allReports']);

// });
