<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shared Report - Tammeny</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
</head>
<body class="bg-slate-50">
<div class="min-h-screen flex flex-col">

    <!-- Header -->
    <div class="bg-white border-b border-slate-200 px-6 py-4 shadow-sm">
        <div class="flex items-center justify-between max-w-4xl mx-auto w-full">
            <div>
                <h1 class="text-2xl font-bold text-slate-900">Shared Report Analysis</h1>
                <p class="text-sm text-slate-600 mt-1">Read-only view of medical report analysis</p>
            </div>
            <div class="flex items-center gap-2">
                <a href="{{ url('/') }}" class="text-blue-600 hover:text-blue-700 font-bold text-xl">Tammeny</a>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="flex-1 px-6 py-6 max-w-4xl mx-auto w-full">

        <!-- Analysis Results -->
        <div id="resultsContainer" class="mb-8 space-y-4">
            @if($report->ocrInputs->first())
                <div style="display: none;" class="bg-white rounded-xl border border-slate-200 p-6">
                    <h3 class="font-bold text-slate-900 mb-3">Analysis Results</h3>
                    <div class="bg-slate-50 rounded-lg p-4 overflow-auto max-h-40">
                        <pre class="text-xs text-slate-700">{{ $report->ocrInputs->first()->ocr_text }}</pre>
                    </div>
                </div>
            @endif

            <!-- We don't store the initial explanation in the report model directly for Lab Reports, 
                 it's usually in the chat history. So we just show the chat history. -->
        </div>

        <!-- Chat History -->
        <div class="bg-white rounded-xl border border-slate-200 flex flex-col" style="height: 600px;">
            <div class="p-4 border-b border-slate-200 bg-slate-50 rounded-t-xl">
                <h3 class="font-semibold text-slate-700">Conversation History</h3>
            </div>

            <div id="chatContainer" class="flex-1 overflow-y-auto p-6 space-y-4">
                @foreach($report->chatMessages as $msg)
                    <!-- User Message -->
                    <div class="flex items-end gap-3 justify-end">
                        <div class="bg-blue-600 text-white rounded-2xl rounded-br-sm px-4 py-3 max-w-md">
                            <p class="text-sm">{{ $msg->message }}</p>
                        </div>
                    </div>

                    <!-- AI Response -->
                    <div class="flex items-start gap-3">
                        <div class="bg-slate-200 text-slate-900 rounded-2xl rounded-bl-sm px-4 py-3 max-w-2xl">
                            @if($msg->response_en)
                                <p class="text-sm font-medium">{{ $msg->response_en }}</p>
                            @endif
                            @if($msg->response_ar)
                                <p class="text-sm text-slate-600 mt-2">{{ $msg->response_ar }}</p>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>
            
            <div class="p-4 border-t border-slate-200 text-center text-slate-500 text-sm">
                This is a read-only view. <a href="{{ route('login') }}" class="text-blue-600 hover:underline">Log in</a> to create your own reports.
            </div>
        </div>

    </div>
</div>
</body>
</html>
