<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Medical AI Assistant</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>

<body class="bg-gradient-to-br from-slate-50 to-slate-100 min-h-screen flex flex-col">
    <!-- Navbar -->
    <nav class="bg-white border-b border-slate-200 sticky top-0 z-50 w-full">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between h-16">
                <div class="flex items-center gap-8">
                    <a href="{{ url('/') }}" class="flex-shrink-0 flex items-center gap-2">
                        <div class="w-8 h-8 bg-blue-600 rounded-lg flex items-center justify-center text-white font-bold text-lg">T</div>
                        <span class="font-bold text-xl tracking-tight text-slate-900">Tammeny</span>
                    </a>
                    <div class="hidden md:flex gap-6">
                        <a href="{{ route('home') }}" class="text-sm font-medium text-blue-600">Home</a>
                        <a href="{{ route('ehr.index') }}" class="text-sm font-medium text-slate-600 hover:text-blue-600 transition-colors">My Records</a>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    @auth
                        <div class="flex items-center gap-3 pl-6 border-l border-slate-200">
                            <span class="text-sm font-medium text-slate-700">{{ Auth::user()->name }}</span>
                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <button type="submit" class="text-sm text-slate-500 hover:text-red-600 transition-colors">Logout</button>
                            </form>
                        </div>
                    @else
                        <div class="flex items-center gap-4">
                            <a href="{{ route('login') }}" class="text-sm font-medium text-slate-600 hover:text-slate-900">Log in</a>
                            @if (Route::has('register'))
                                <a href="{{ route('register') }}" class="text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 px-4 py-2 rounded-lg transition-colors">Register</a>
                            @endif
                        </div>
                    @endauth
                </div>
            </div>
        </div>
    </nav>
    

    <div class="flex-grow flex items-center justify-center w-full">
        <div class="w-full max-w-2xl px-6 py-12">

            <!-- Header -->
            <div class="text-center mb-12">
            <h1 class="text-4xl font-bold text-slate-900 mb-2">Medical AI Assistant</h1>
            <p class="text-lg text-slate-600">Analyze reports and X-rays with AI-powered insights</p>
        </div>

        <!-- Cards Grid -->
        <div class="grid md:grid-cols-2 gap-6">

            <!-- Chat with Report -->
            <a href="{{ route('reports.index') }}" class="group">
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 p-8 cursor-pointer border-2 border-transparent hover:border-blue-500">
                    <div class="flex flex-col items-center text-center">
                        <div class="w-16 h-16 bg-blue-100 rounded-full flex items-center justify-center mb-4 group-hover:bg-blue-200 transition-colors">
                            <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <h2 class="text-2xl font-bold text-slate-900 mb-2">Chat with Report</h2>
                        <p class="text-slate-600">Paste your medical report and get AI analysis</p>
                    </div>
                </div>
            </a>

            <!-- Chat with X-Ray -->
            <a href="{{ route('radiology.index') }}" class="group">
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 p-8 cursor-pointer border-2 border-transparent hover:border-green-500">
                    <div class="flex flex-col items-center text-center">
                        <div class="w-16 h-16 bg-green-100 rounded-full flex items-center justify-center mb-4 group-hover:bg-green-200 transition-colors">
                            <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                            </svg>
                        </div>
                        <h2 class="text-2xl font-bold text-slate-900 mb-2">Chat with X-Ray</h2>
                        <p class="text-slate-600">Upload X-ray images for detailed analysis</p>
                    </div>
                </div>
            </a>

            <!-- My Health Records (EHR) -->
            <a href="{{ route('ehr.index') }}" class="group md:col-span-2">
                <div class="bg-white rounded-2xl shadow-lg hover:shadow-2xl transition-all duration-300 p-8 cursor-pointer border-2 border-transparent hover:border-purple-500">
                    <div class="flex flex-col items-center text-center">
                        <div class="w-16 h-16 bg-purple-100 rounded-full flex items-center justify-center mb-4 group-hover:bg-purple-200 transition-colors">
                            <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"/>
                            </svg>
                        </div>
                        <h2 class="text-2xl font-bold text-slate-900 mb-2">My Health Records</h2>
                        <p class="text-slate-600">Access your past reports and chat history</p>
                    </div>
                </div>
            </a>
        </div>

        <!-- Footer -->
        <div class="mt-12 text-center">
            <p class="text-slate-500 text-sm">Powered by Tammeny Team</p>
        </div>
        </div>
    </div>
</body>
</html>
