<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('reports', 'share_token')) {
            Schema::table('reports', function (Blueprint $table) {
                $table->string('share_token')->nullable()->unique()->after('title');
            });
        }

        if (!Schema::hasColumn('radiology_reports', 'share_token')) {
            Schema::table('radiology_reports', function (Blueprint $table) {
                $table->string('share_token')->nullable()->unique();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('reports', function (Blueprint $table) {
            $table->dropColumn('share_token');
        });

        Schema::table('radiology_reports', function (Blueprint $table) {
            $table->dropColumn('share_token');
        });
    }
};
