<?php
namespace App\Services;

use Illuminate\Support\Facades\Http;
use App\Models\RadiologyReport;

class RadiologyVisionService
{
    protected string $model = 'gemini-2.5-flash';
    public function analyzeImage(string $imagePath, string $relativePath, int $userId): RadiologyReport
    {
        $mime = mime_content_type($imagePath);
        $raw  = base64_encode(file_get_contents($imagePath));

        $payload = [
            "contents" => [
                [
                    "parts" => [
                        [
                            "text" => "You are an image understanding assistant. Do NOT provide diagnoses, treatment, medications, or direct clinical recommendations.
                    Analyze ONLY the provided medical image and RETURN JSON ONLY that exactly matches the schema below.

                    Required JSON schema (RETURN ONLY JSON, nothing else):

                    {
                    \"image_summary\": \"short one-line neutral description of what the image shows\",
                    \"observations\": [
                        {
                        \"region\": \"anatomical region (e.g., 'tibia mid-diaphysis')\",
                        \"type\": \"choose one: lucency | cortical_disruption | angulation | displacement | soft_tissue_swelling | normal\",
                        \"description\": \"brief neutral sentence describing the finding (no diagnosis words)\",
                        \"confidence\": 0.0
                        }
                    ],
                    \"flags\": {
                        \"abnormality_present\": true,
                        \"urgent_attention_suggested\": false
                    }
                    }

                    Rules:
                    - Use only the fields above and no extra keys.
                    - Use neutral descriptive language only (e.g., 'linear lucency across bone cortex' NOT 'fracture').
                    - If you are >=90% certain an acute structural break is present, set abnormality_present=true and urgent_attention_suggested=true and use \"cortical_disruption\" or \"discontinuity\" for type — still avoid the word \"fracture\".
                    - Confidence must be a number between 0.0 and 1.0.
                    - Return JSON only, do NOT add any commentary or explanation."
                        ],
                        [
                            "inline_data" => [
                                "mime_type" => $mime,
                                "data" => $raw
                            ]
                        ]
                    ]
                ]
            ]
        ];

        // $baseUrl = env('GOOGLE_API_URL', 'https://generativelanguage.googleapis.com/v1beta');
        $baseUrl = 'https://generativelanguage.googleapis.com/v1beta';
        $url = "{$baseUrl}/models/{$this->model}:generateContent";

        $response = Http::withHeaders([
            "Content-Type" => "application/json",
            // "x-goog-api-key" => env("GOOGLE_API_KEY")
            "x-goog-api-key" => "AIzaSyD6hy6BFFTXxACZmnkNgwN1143vrgiWGkQ"
        ])->post($url, $payload);

        $data = $response->json();

        // echo"<pre>";print_r($data);die();
        $rawText = $data['candidates'][0]['content']['parts'][0]['text'] ?? '{}';
        $clean = preg_replace('/```json|```/', '', $rawText);
        $clean = trim($clean);
        $decoded = json_decode($clean, true);
        // echo"<pre>";print_r($decoded);die();

        return RadiologyReport::create([
            'user_id' => $userId,
            'image_path' => $relativePath,
            'raw_json' => json_encode($decoded),
            'findings' => null,
            'impression' => null
        ]);
    }







    // ######## Paid version ########
    // protected string $model = 'gpt-4.1'; // Updated model name gpt-4o to gpt-4.1

    // public function analyzeImage(string $imagePath, int $userId): RadiologyReport
    // {
    //     $prompt = "
    //     You are a radiology analysis assistant.
    //     Analyze the medical image and return JSON ONLY in this exact format:

    //     {
    //         \"findings\": \"...\",
    //         \"impression\": \"...\",
    //         \"severity\": \"mild | moderate | severe | normal\",
    //         \"ai_confidence\": \"0.0 - 1.0\"
    //     }

    //     Rules:
    //     - No diagnosis.
    //     - Awareness only.
    //     - Keep impression short.
    //     ";

    //     $response = Http::withHeaders([
    //         "Authorization" => "Bearer ".env("OPENAI_API_KEY"),
    //         "Content-Type" => "application/json"
    //     ])->post("https://api.openai.com/v1/chat/completions", [
    //         "model" => $this->model,
    //         "messages" => [
    //             [
    //                 "role" => "user",
    //                 "content" => [
    //                     [
    //                         "type" => "text",
    //                         "text" => $prompt
    //                     ],
    //                     [
    //                         "type" => "image_url",
    //                         "image_url" => [
    //                             "url" => asset('storage/' . $imagePath)
    //                         ]
    //                     ]
    //                 ]
    //             ]
    //         ]
    //     ]);

    //     $data = $response->json();

    //     echo"<pre>";print_r($data);die();
    //     // Extract output text
    //     $rawText = $data['choices'][0]['message']['content'] ?? '{}';

    //     // Decode JSON
    //     $decoded = json_decode($rawText, true);

    //     return RadiologyReport::create([
    //         'user_id'       => $userId,
    //         'image_path'    => $imagePath,
    //         'findings'      => $decoded['findings'] ?? null,
    //         'impression'    => $decoded['impression'] ?? null,
    //         'severity'      => $decoded['severity'] ?? null,
    //         'ai_confidence' => $decoded['ai_confidence'] ?? null,
    //         'raw_json'      => $rawText
    //     ]);
    // }
}
