<?php
namespace App\Services;

use Illuminate\Support\Facades\Http;
use App\Models\RadiologyMessage;

class RadiologyChatService
{
    // protected string $model = 'gpt-4o-mini';
    protected string $model = 'llama-3.3-70b-versatile';

    public function chatWithRadiology(array $reportJson, string $userMessage, int $reportId, int $userId): array
    {
        $systemPrompt = "
        You are a medical awareness assistant (NOT a diagnostic tool).
        Only return JSON:

        {
            \"en\": \"English explanation\",
            \"ar\": \"Arabic explanation\"
        }

        Rules:
        - English must be simple, clear, professional and conversational.
        - Arabic must be simple, clear, professional and Egyption.
        - No diagnosis.
        - Awareness only.
        - Use observations to explain in simple Arabic then English what the image likely shows (awareness only).
        - Do NOT provide a diagnosis or treatment, only advice to consult doctor when necessary.
        - Mention which findings need urgent attention if flags. Use simple wording.
        - Use radiology_report_json as context.

        Important:  
        - Arabic must be grammatically correct, fluid, and natural with NO machine-translation artifacts.  
        - Avoid literal translation.  
        - Make Arabic the primary language tone; use simple conversational Arabic.  
        - English should be clean, structured, and medically accurate.
        - Do NOT provide a diagnosis or treatment, only advice to consult doctor when necessary.
        - Your Name is Tammeny

        radiology_report_json: ".json_encode($reportJson);

        // HISTORY
        $history = RadiologyMessage::where('report_id', $reportId)
            ->orderBy('created_at')
            ->get()
            ->flatMap(function ($msg) {
                return [
                    ["role" => "user", "content" => $msg->message],
                    ["role" => "assistant", "content" =>
                        "Previous Arabic Answer:\n" . $msg->response_ar .
                        "\n\nPrevious English Answer:\n" . $msg->response_en
                    ]
                ];
            })->toArray();

        $messages = array_merge(
            [["role" => "system", "content" => $systemPrompt]],
            $history,
            [["role" => "user", "content" => $userMessage]]
        );
        // echo"<pre>";print_r($messages);die();
        // $response = Http::withHeaders([
        //     // "Authorization" => "Bearer ".env("OPENAI_API_KEY"),
        //     "Authorization" => "Bearer ".env("GROQ_API_KEY"),
        //     "Content-Type" => "application/json"
        // ])->post(env('GROQ_API_URL', 'https://api.groq.com/openai/v1/chat/completions'), [
        $api_key = "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";
        $response = Http::withHeaders([
            // "Authorization" => "Bearer ".env("OPENAI_API_KEY"),
            "Authorization" => "Bearer ". $api_key,
            "Content-Type" => "application/json"
        ])->post('https://api.groq.com/openai/v1/chat/completions', [
        // ])->post(env('OPENAI_API_URL', 'https://api.openai.com/v1/chat/completions'), [
            "model" => $this->model,
            "messages" => $messages
        ]);

        $data = $response->json();
        $raw = $data['choices'][0]['message']['content'] ?? '{}';

        $decoded = json_decode($raw, true);

        return [
            'ar' => $decoded['ar'] ?? 'Missing Arabic',
            'en' => $decoded['en'] ?? 'Missing English'
        ];
    }
}
