<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class GeminiService
{
    protected string $model = 'models/gemini-2.5-flash';

     public function chatWithLab(array $labData, string $userMessage): array
    {
        // system prompt to force bilingual output in JSON
        $systemPrompt = "
        You are a medical awareness assistant (NOT a diagnostic tool).
        You must always return the output in the following JSON structure ONLY:

        {
        \"ar\": \"Arabic explanation here\",
        \"en\": \"English explanation here\"
        }

        Rules:
        - Arabic response must use clear, simple, conversational Arabic (not classical).
        - English response must be professional but simple.
        - No diagnosis. No medications. No treatment plans.
        - Provide awareness only: meaning of lab results, what they usually indicate, and when to see a doctor.
        - Use the provided lab_data as context.

        lab_data JSON:" . json_encode($labData);

        $payload = [
            "contents" => [
                [
                    "parts" => [
                        ["text" => $systemPrompt],
                        ["text" => $userMessage]
                    ]
                ]
            ],
            "temperature" => 0.2,
            "max_output_tokens" => 1024
        ];

        // $baseUrl = env('GOOGLE_API_URL', 'https://generativelanguage.googleapis.com/v1beta');
        $baseUrl = 'https://generativelanguage.googleapis.com/v1beta';
        $url = "{$baseUrl}/models/{$this->model}:generateContent";

        $response = Http::withHeaders([
            'Content-Type' => 'application/json',
            // 'x-goog-api-key' => env('GOOGLE_API_KEY')
            'x-goog-api-key' => "AIzaSyD6hy6BFFTXxACZmnkNgwN1143vrgiWGkQ"
        ])->post($url, $payload);

        return $response->json();
    }

    public static function extractTextFromResponse(array $resp): array
    {
        // Try extracting the text from common fields
        $rawText = $resp['candidates'][0]['content'][0]['text']
            ?? $resp['candidates'][0]['text']
            ?? json_encode($resp);

        // try to decode JSON structure
        $decoded = json_decode($rawText, true);

        if (json_last_error() === JSON_ERROR_NONE && is_array($decoded)) {
            return [
                'ar' => $decoded['ar'] ?? '❌ Arabic version missing',
                'en' => $decoded['en'] ?? '❌ English version missing',
            ];
        }

        return [
            'ar' => '❌ Could not decode Arabic text',
            'en' => $rawText
        ];
    }

    public function analyzeLabImage($imagePath): array
    {
        $mime = mime_content_type($imagePath);
        $raw  = base64_encode(file_get_contents($imagePath));

        $payload = [
            "contents" => [
                [
                    "parts" => [
                        [
                            // "text" => "You are a medical lab interpreter. Analyze this lab result and highlight abnormal values. Mention possible conditions. Do NOT provide diagnosis or treatment. Always recommend consulting a doctor. Return JSON with summary, possible_conditions, advice."
                            "text" => "You are an OCR engine. Extract all text from the provided lab result image accurately. Do NOT interpret or analyze the text. Return the full text content only."
                        ],
                        [
                            "inline_data" => [
                                "mime_type" => $mime,
                                "data" => $raw
                            ]
                        ]
                    ]
                ]
            ]
        ];

        // $baseUrl = env('GOOGLE_API_URL', 'https://generativelanguage.googleapis.com/v1beta');
        $baseUrl = 'https://generativelanguage.googleapis.com/v1beta';
        $response = Http::withHeaders([
            "Content-Type" => "application/json",
            // "x-goog-api-key" => env("GOOGLE_API_KEY")
            "x-goog-api-key" => "AIzaSyD6hy6BFFTXxACZmnkNgwN1143vrgiWGkQ"
        ])->post(
            "{$baseUrl}/models/gemini-2.5-flash:generateContent",
            $payload
        );

        return $response->json();
    }
}
