<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use App\Models\ChatMessage;

class ChatGptService
{
    // protected string $model = 'gpt-4o-mini';
    protected string $model = 'llama-3.3-70b-versatile';

    public function chatWithLab(array $labData, string $userMessage, int $reportId, int $userId): array
    {
        // SYSTEM PROMPT
        $systemPrompt = "
        You are a medical awareness assistant (NOT a diagnostic tool).
        Always return JSON ONLY:

        {
            \"ar\": \"Arabic explanation here\",
            \"en\": \"English explanation here\"
        }

        Rules:
        - Arabic must be clear, simple, conversational.
        - English must be professional but simple.
        - No diagnosis, no treatment plans, awareness only.
        - Use the provided lab_data as context.

        Important:  
        - Arabic must be grammatically correct, fluid, and natural with NO machine-translation artifacts.  
        - Avoid literal translation.  
        - Make Arabic the primary language tone; use simple conversational Arabic.  
        - English should be clean, structured, and medically accurate.
        - Your Name is Tammeny


        lab_data JSON: " . json_encode($labData);

        // HISTORY
        $history = ChatMessage::where('report_id', $reportId)
            ->orderBy('created_at')
            ->get()
            ->flatMap(function ($msg) {
                return [
                    [
                        "role" => "user",
                        "content" => $msg->message
                    ],
                    [
                        "role" => "assistant",
                        "content" =>
                            "Previous Arabic Answer:\n" . $msg->response_ar .
                            "\n\nPrevious English Answer:\n" . $msg->response_en
                    ]
                ];
            })->toArray();

        // FINAL MESSAGES ARRAY
        $messages = array_merge(
            [
                ["role" => "system", "content" => $systemPrompt]
            ],
            $history,
            [
                ["role" => "user", "content" => $userMessage]
            ]
        );

        // echo"<pre>";print_r($messages);die();

        $payload = [
            "model" => $this->model,
            "messages" => $messages,
            "temperature" => 0.2,
            // "max_tokens" => 1024
        ];

        // $response = Http::withHeaders([
        //     // "Authorization" => "Bearer " . env("OPENAI_API_KEY"),
        //     "Authorization" => "Bearer " . env("GROQ_API_KEY"),
        //     "Content-Type" => "application/json"
        // ])->post(env('GROQ_API_URL', 'https://api.groq.com/openai/v1/chat/completions'), $payload);
        $api_key = "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";
        $response = Http::withHeaders([
            // "Authorization" => "Bearer " . env("OPENAI_API_KEY"),
            "Authorization" => "Bearer " . $api_key,
            "Content-Type" => "application/json"
        ])->post('https://api.groq.com/openai/v1/chat/completions', $payload);
        // ])->post(env('OPENAI_API_URL', 'https://api.openai.com/v1/chat/completions'), $payload);

        $data = $response->json();

        // DEBUG ( temporary )
        // echo "<pre>"; print_r($data); die();

        // ----------------------------------------
        // استخراج النص
        // ----------------------------------------
        // Log the full response for debugging
        \Log::info('OpenAI Response:', ['data' => $data]);
        
        $rawText = $data['choices'][0]['message']['content'] ?? '{}';
        
        // // Log the raw text
        // \Log::info('Raw Text from OpenAI:', ['rawText' => $rawText]);

        $decoded = json_decode($rawText, true);
        
        // Log the decoded result
        // \Log::info('Decoded JSON:', ['decoded' => $decoded]);
        
        // echo "<script>console.log('Raw Text: ' + '$data');</script>";
        $ar = $decoded['ar'] ?? '❌ Arabic missing';
        $en = $decoded['en'] ?? '❌ English missing';

        return ['ar' => $ar, 'en' => $en];
    }
}