<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Report extends Model
{
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function ocrInputs()
    {
        return $this->hasMany(OcrInput::class);
    }

    public function chatMessages()
    {
        return $this->hasMany(ChatMessage::class);
    }

    protected $fillable = [
        'user_id',
        'title'
    ];
}
