<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Report;
use App\Models\RadiologyReport;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;

class ShareController extends Controller
{
    public function generateLink(Request $request, $type, $id)
    {
        $validator = \Illuminate\Support\Facades\Validator::make(
            ['type' => $type, 'id' => $id],
            [
                'type' => 'required|in:report,radiology',
                'id' => 'required|integer'
            ]
        );

        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => $validator->errors()->first()
            ], 422);
        }

        try {
            if ($type === 'report') {
                $item = Report::where('id', $id)->where('user_id', Auth::id())->firstOrFail();
                $routeName = 'share.report';
            } else {
                $item = RadiologyReport::where('id', $id)->where('user_id', Auth::id())->firstOrFail();
                $routeName = 'share.radiology';
            }

            if (!$item->share_token) {
                $item->share_token = Str::random(32);
                $item->save();
            }

            return response()->json([
                'status' => 'success',
                'url' => route($routeName, ['token' => $item->share_token])
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'status' => 'error',
                'message' => $e->getMessage()
            ], 500);
        }
    }

    public function viewReport($token)
    {
        $report = Report::where('share_token', $token)->firstOrFail();
        return view('share.report', compact('report'));
    }

    public function viewRadiology($token)
    {
        $report = RadiologyReport::where('share_token', $token)->firstOrFail();
        return view('share.xray', compact('report'));
    }
}
