<?php
namespace App\Http\Controllers;

use App\Services\RadiologyVisionService;
use App\Services\RadiologyChatService;
use App\Models\RadiologyMessage;
use App\Models\RadiologyReport;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RadiologyController extends Controller
{
    public function uploadRadiology(Request $request, RadiologyVisionService $vision)
    {
        $request->validate([
            'image' => 'required|image|max:20000',
            // 'user_id' => 'required|integer'
        ]);

        $file = $request->file('image');
        $fileData = \App\Helpers\FileHelper::storeUploadedFile($file, 'radiology');

        $report = $vision->analyzeImage($fileData['full_path'], $fileData['relative_path'], Auth::id());
        
        // Clean up temp file if S3
        \App\Helpers\FileHelper::cleanupTempFile($fileData);

        return response()->json([
            'status' => 'success',
            'analysis' => json_decode($report->raw_json, true),
            'explanation' => $report->impression ?? null,
            'report_id' => $report->id,
            'report' => $report
        ]);
    }

    public function chat(Request $request, RadiologyChatService $chat)
    {
        $request->validate([
            'report_id' => 'required|exists:radiology_reports,id',
            'message' => 'required|string',
            // 'user_id' => 'required|integer'
        ]);

        $report = RadiologyReport::findOrFail($request->report_id);

        $result = $chat->chatWithRadiology(
            json_decode($report->raw_json, true),
            $request->message,
            $report->id,
            Auth::id()
        );

        RadiologyMessage::create([
            'report_id' => $report->id,
            'user_id'   => Auth::id(),
            'message'   => $request->message,
            'response_ar' => $result['ar'],
            'response_en' => $result['en']
        ]);

        return response()->json([
            'status' => 'success',
            'response_ar' => $result['ar'],
            'response_en' => $result['en']
        ]);
    }

    public function getReport($report_id)
    {
        $report = RadiologyReport::findOrFail($report_id);

        return response()->json([
            "status" => "success",
            "report" => $report
        ]);
    }


    public function history($report_id)
    {
        $messages = RadiologyMessage::where('report_id', $report_id)
            ->orderBy('created_at')
            ->get();

        return response()->json([
            "status" => "success",
            "history" => $messages
        ]);
    }

    // public function allReports()
    // {
    //     $reports = RadiologyReport::where('user_id', auth()->id())
    //         ->orderBy('created_at', 'desc')
    //         ->get();

    //     return response()->json([
    //         "status" => "success",
    //         "reports" => $reports
    //     ]);
    // }


    public function show($id)
    {
        $report = RadiologyReport::where('id', $id)->where('user_id', Auth::id())->firstOrFail();
        return view('chat-xray', ['report' => $report]);
    }
}