<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Report;
use App\Models\RadiologyReport;
use Illuminate\Support\Facades\Auth;

class EHRController extends Controller
{
    public function index()
    {
        $reports = Report::where('user_id', Auth::id())
            ->orderBy('created_at', 'desc')
            ->get();

        $radiologyReports = RadiologyReport::where('user_id', Auth::id()) // Assuming RadiologyReport has user_id, need to verify or join if not
             ->orderBy('created_at', 'desc')
             ->get();
             
        // Double check RadiologyReport model structure if user_id is direct or via relationship
        // Based on RadiologyController upload, it seems to use Auth::id() but let's check the model if needed. 
        // Wait, in RadiologyController: $vision->analyzeImage($fullPath, Auth::id());
        // And RadiologyReport model likely has user_id.

        return view('ehr.dashboard', compact('reports', 'radiologyReports'));
    }
}
