<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Report;
use App\Models\OcrInput;
use App\Models\ChatHistory;
use App\Models\ChatMessage;
use App\Services\GeminiService;
use App\Services\ChatGptService;
use Illuminate\Support\Facades\Auth;

class ChatBotController extends Controller
{
    public function startReport(Request $request)
    {
        // 'user_id' => $request->user()->id,
        $report = Report::create([
            'user_id' => Auth::id(),
            'title' => $request->title ?? 'Report - ' . now()->format('Y-m-d H:i'),
        ]);


        return response()->json([
            'report_id' => $report->id,
            'message' => 'Report started successfully.'
        ]);
    }

    public function uploadLabImage(Request $request, GeminiService $gemini)
    {
        $request->validate([
            'image' => 'required|image|max:8000',
            'report_id' => 'required|exists:reports,id'
        ]);

        $file = $request->file('image');
        $fileData = \App\Helpers\FileHelper::storeUploadedFile($file, 'lab-reports');

        $ocrResponse = $gemini->analyzeLabImage($fileData['full_path']);
        
        // Clean up temp file if S3
        \App\Helpers\FileHelper::cleanupTempFile($fileData);
        // echo"<pre>"; print_r($ocrResponse);die();
        $rawText = $ocrResponse['candidates'][0]['content']['parts'][0]['text'] ?? null;

        $ocrInput = OcrInput::create([
            'report_id' => $request->report_id,
            // 'user_id' => $request->user()->id,
            'user_id' => Auth::id(),
            'original_file_name' => $fileData['relative_path'],
            'ocr_text' => $rawText,
        ]);

        return response()->json([
            'status' => 'success',
            'ocr_id' => $ocrInput->id,
            'ocr_text' => $rawText
        ]);
    }

    public function chatWithReport(Request $request, ChatGptService $chatGpt)
    {
        $request->validate([
            'report_id' => 'required|exists:reports,id',
            'message' => 'required|string'
        ]);

        $report = Report::findOrFail($request->report_id);

        // نجمع كل OCR inputs الخاصة بالـ report
        $labData = $report->ocrInputs()->pluck('ocr_text')->toArray();
        // echo "<pre>";print_r($labData);die();
        // نرسلها للـ LLM
        // $llmResponse = $gemini->chatWithLab($labData, $request->message);
        // $responseText = GeminiService::extractTextFromResponse($llmResponse);
        // $llmResponse = $chatGpt->chatWithLab($labData, $request->message, $report->id, $request->user()->id);
        $responseText = $chatGpt->chatWithLab($labData, $request->message, $report->id, Auth::id());
        // echo"<pre>";print_r($responseText);die();
        // $responseText = $llmResponse;

        // نحفظ الرسالة في الـ ChatHistory
        $message = $request->message;
        if($message == 'Please analyze the uploaded report and provide a concise, plain-language summary in English.')
        {
            $message = '.';
        }
        $chatMessage = ChatMessage::create([
            'report_id' => $report->id,
            // 'role'      => $request->role,
            // 'user_id' => $request->user()->id,
            'user_id' => Auth::id(),
            'message' => $message,
            'response_ar' => $responseText['ar'],
            'response_en' => $responseText['en']
        ]);

        return response()->json([
            'status' => 'success',
            'chat' => [
                'id' => $chatMessage->id,
                'message' => $request->message,
                'response_ar' => $responseText['ar'],
                'response_en' => $responseText['en']
            ]
        ]);
    }

    // استرجاع كل الـ chat history لreport معين
    public function getReportHistory(Request $request, $report_id)
    {
        $history = ChatMessage::where('report_id', $report_id)
            ->orderBy('created_at')
            ->get(['message', 'response_ar', 'response_en', 'created_at']);

        return response()->json([
            'status' => 'success',
            'history' => $history
        ]);
    }

    public function show($id)
    {
        $report = Report::where('id', $id)->where('user_id', Auth::id())->firstOrFail();
        return view('chat-report', ['report' => $report]);
    }
}