<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Services\GeminiService;
use App\Models\OcrInput;
use App\Models\Report;

class AIController extends Controller
{

    public function analyzeLabImage(Request $request, GeminiService $gemini)
    {
        $request->validate([
            'image' => 'required|image|max:8000',
            'report_id' => 'required|exists:reports,id',
        ]);

        $file = $request->file('image');
        $fileData = \App\Helpers\FileHelper::storeUploadedFile($file, 'lab-reports');

        $ocrResult = $gemini->analyzeLabImage($fileData['full_path']);
        
        // Clean up temp file if S3
        \App\Helpers\FileHelper::cleanupTempFile($fileData);

        $rawText = $ocrResult['candidates'][0]['content'][0]['text'] ?? null;

        $ocrInput = OcrInput::create([
            'report_id' => $request->report_id,
            'user_id' => $request->user()->id,
            'original_file_name' => $fileData['relative_path'],
            'ocr_text' => $rawText,
        ]);

        return response()->json([
            'status' => 'success',
            'ocr_input_id' => $ocrInput->id,
            'ocr_text' => $ocrInput->ocr_text,
        ]);
    }


}