<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\GeminiService;

class AIChatController extends Controller
{
    public function chat(Request $request, GeminiService $gemini)
    {
        $request->validate([
            'message' => 'required|string',
            'lab_data' => 'required|array'
        ]);

        $message = $request->input('message');
        $labData = $request->input('lab_data');

        $resp = $gemini->chatWithLab($labData, $message);

        // extract bilingual reply
        $reply = GeminiService::extractTextFromResponse($resp);

        return response()->json([
            'status' => 'success',
            'reply'  => $reply,
            'raw'    => $resp
        ]);
    }
}
